'use strict';

angular.module('gpw_types_model', ['configuration_model'])
    .factory('GpwType', ['GpwIndex', '$q', 'Configuration', '$http', function(GpwIndex, $q, Configuration, $http){
        function GpwType(gpwTypeData){
            this.setData(gpwTypeData);
        }

        GpwType.prototype = {
            dataLoaded: false,
            setData: function(gpwTypeData){
                var scope = this;
                angular.extend(scope, gpwTypeData);
                scope.indexes = new Array();
            },
            getSessions: function(callback){
                if(this.dataLoaded){
                    callback();
                } else {
                    this.loadGpwIndexes();
                    callback();
                }

            }
            ,loadGpwIndexes: function(){
                var scope = this;
                var deferred = $q.defer();
                $http.get(Configuration.urlQuotesForMarket, {params: {'gpwTypeId':scope.id}})
                    .success(function(data){//console.log(data);

                        for(var i=0;i<data[0].indexes.length;i++){
                            scope.indexes.push(new GpwIndex(data[0].indexes[i]));
                            //scope.list.push(new GpwType(data[i]));
                        }
                        scope.dataLoaded = true;

                        deferred.resolve(scope.list);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }


        }

        return GpwType;
    }])
    .factory('GpwIndex', ['GpwSession', function(GpwSession){
        function GpwIndex(gpwIndexData){
            this.setData(gpwIndexData)
        }

        GpwIndex.prototype = {
            setData: function(gpwIndexData){
                var scope = this;
                angular.extend(scope, gpwIndexData.data);
                scope.actualSession = new GpwSession(gpwIndexData.actualSession);
                scope.prevSession = new GpwSession(gpwIndexData.prevSession);
            }
        }

        return GpwIndex;
    }])
    .factory('GpwSession', [function(){
        function GpwSession(gpwSessionData){
            this.setData(gpwSessionData)
        }

        GpwSession.prototype = {
            setData: function(gpwSessionData){
                var scope = this;
                angular.extend(scope, gpwSessionData);
            }
        }

        return GpwSession;
    }])
    .factory('QuotesManager', ['$http', '$q', '$rootScope', 'Configuration', 'GpwType', function($http, $q, $rootScope, Configuration, GpwType){
        var QuotesManager = {
            list: []
            ,_isLoadedData: false
            ,_getItem: function(id){
                var item = false;
                this.list.forEach(function(Item){
                    if(Item.id == id)
                    {
                        item = Item;
                    }
                });
                return item;
            }
            ,loadGpwTypesList: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(Configuration.urlQuotesGpwTypes)
                    .success(function(data){//console.log(data);
                        for(var i=0;i<data[0].length;i++){
                            scope.list.push(new GpwType(data[0][i]));
                        }
                        scope._isLoadedData = true;

                        deferred.resolve(scope.list);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }
        }

        return QuotesManager;
    }])
    .factory('IndicatorsManager', ['$http', '$q', '$rootScope', 'Configuration', function($http, $q, $rootScope, Configuration){
        var IndicatorsManager = {
            data: {}
            ,_isLoadedData: false
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.data;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(Configuration.urlIndicators)
                    .success(function(data){
//                        scope.list = data;
                        angular.extend(scope.data, data);

                        scope._isLoadedData = true;

                        deferred.resolve(scope.data);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }
        }

        return IndicatorsManager;
    }])
    .factory('CurrencyManager', ['$http', '$q', '$rootScope', 'Configuration', 'GpwIndex', function($http, $q, $rootScope, Configuration, GpwIndex){
        var CurrencyManager = {
            list: []
            ,_isLoadedData: false
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var scope = this;
                var deferred = $q.defer();
                $http.get(Configuration.urlCurrency)
                    .success(function(data){//console.log(data);
                        for(var i=0;i<data.length;i++){
                            scope.list.push(new GpwIndex(data[i]));
                        }
                        scope._isLoadedData = true;

                        deferred.resolve(scope.list);
                    })
                    .error(function(){
                        deferred.reject();
                    })
                ;
                return deferred.promise;
            }
        }

        return CurrencyManager;
    }])
;